/******************************************************************************/
class PlaySound : BaseEvent
{
public:
            PlaySound();
   virtual ~PlaySound();
   
   virtual void create(Object &obj); 
   virtual void AfterCreate(      ); 

   virtual Bool update();
   
private:

   void CallTriggeredAction();
   void StopTriggeredAction();

   VarAudio* m_VarAudio;
   UID m_VarAudioUID;
   
   flt m_Volume, m_FadeInTime;
   bool m_Loop, m_Global;
   Vec m_Pos;
};
/******************************************************************************/
PlaySound::PlaySound() : BaseEvent(), m_Volume(0), m_VarAudio(null), m_FadeInTime(0), m_Loop(false), m_Global(false), m_Pos(0)                
{
   
}
PlaySound::~PlaySound()
{
   
}
/******************************************************************************/
void PlaySound::create(Object &obj)
{
   // Getting the parameters from the object in the world
   if(Param *p = obj.findParam("FadeInTime"))  m_FadeInTime  = p.asFlt();
   if(Param *p = obj.findParam("VarAudioUID")) m_VarAudioUID = p.asID();            
   if(Param *p = obj.findParam("Global"))      m_Global      = p.asBool();
   if(Param *p = obj.findParam("Loop"))        m_Loop        = p.asBool();
   if(Param *p = obj.findParam("Position"))    m_Pos         = p.asVec();
   if(Param *p = obj.findParam("Volume"))      m_Volume      = p.asFlt(); 
   
   super.create(obj); // Create the BaseEvent params too
}
/******************************************************************************/
void PlaySound::AfterCreate()
{
   // Find the correct VarAudio to work on. This has to be done here, because it's unreliable during create() (not all objects are loaded yet)
   REPA(variablesAudio)
      if(variablesAudio[i].id() == m_VarAudioUID)
            m_VarAudio = &variablesAudio[i]; 
            
   DEBUG_ASSERT(m_VarAudio, "Audio not found in scene");
}
/******************************************************************************/
bool PlaySound::update()
{
   super.update(); // Update the BaseEvent
   
   if(m_EventCalled)
   {
         // Update 3D sound
      if(!m_Global && m_VarAudio->GetAudio().playing()) 
      {
         m_VarAudio->GetAudio().pos(m_Pos);
         Listener.orn(Cam.matrix.z, Cam.matrix.y)  // set listener orientation (from camera)
                 .pos(Cam.matrix.pos            ); // set listener position    (from camera)
      }   
   }

   return true; 
}
/******************************************************************************/
// This method is called when the event was triggered, taking the delay into account
void PlaySound::CallTriggeredAction()
{
   if(m_Global) 
   {
      m_VarAudio->GetAudio().create(m_VarAudio->GetAudioFile(), m_Loop, m_Volume); // Play the sound across the entire level
   }
   else 
   {
      m_VarAudio->GetAudio().create(m_VarAudio->GetAudioFile(), m_Pos, 1, m_Loop, m_Volume); // 3D sound
   }
      
   if(m_FadeInTime > 0.0f)
   {
      m_VarAudio->GetAudio().fadeInFromSilence(m_FadeInTime);    
   }
   
   //m_VarAudio->GetAudio().speed(3.0f);
   m_VarAudio->GetAudio().play();
}

// This method is called when the duration of the event has been reached
void PlaySound::StopTriggeredAction()
{
   m_VarAudio->GetAudio().stop();
   m_VarAudio->GetAudio().del();
}
/******************************************************************************/